package w83b.w83bManager;



import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bCertificacionesBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;






public class W83bCertificaciones implements W83bICertificaciones{

	
	
	
	public W83bCertificacionesBean cargaCertificacion(W83bCertificacionesBean param) throws Exception {
		// TODO Auto-generated method stub
		W83bCertificacionesBean certificacion=param;
		String territorioBusqueda=certificacion.getTerritorio();
		certificacion.setTerritorio(certificacion.getUsuarioBean().getCodTerritorioDelegacion());
		W83bCertificacionesBean miCertificacion = new W83bCertificacionesBean();
		//Recupero el nombre del firmante
		String nFirmante = W83bFactoriaDAO.getCertificacionesDAO().recuperarNombreFirmante(certificacion);
		String[] nf=nFirmante.split("\\|");
		String nombreFirmante="";
		String sexoFirmante="";		
		if (nf!=null&&nf.length!=0){
			nombreFirmante = nf[0];
			sexoFirmante = nf[1];
		}
		String cargoFirmante = W83bFactoriaDAO.getCertificacionesDAO().recuperarCargoFirmante(certificacion);
		
		//Recupero la localidad del firmante
		String datos = W83bFactoriaDAO.getCertificacionesDAO().recuperarLocalidadFirmante(certificacion);
		if(StringUtils.isNotEmpty(datos))
				{
				String d[]=datos.split("#");
				certificacion.setDescLocalidadCast(d[0]);
				certificacion.setDescLocalidadEusk(d[1]);
				certificacion.setDescProvinciaCast(d[2]);
				certificacion.setDescProvinciaEusk(d[3]);
				}
		
		certificacion.setFirmante(nombreFirmante);
		String descargo[]=cargoFirmante.split("#");
		if (W83bClsConstantes.CONSTANTE_VARON.equals(sexoFirmante)){
			certificacion.setCargodesc(descargo[0]);
		}else if (W83bClsConstantes.CONSTANTE_MUJER.equals(sexoFirmante)){
			certificacion.setCargodesc(descargo[1]);
		}else{
			certificacion.setCargodesc(descargo[0]+"/"+descargo[1]);
		}
		certificacion.setCargodese(descargo[2]);
		certificacion.setTerritorio(territorioBusqueda);
		
		if("NumeroDelegadosCentralSindical".equals(certificacion.getCertificacion())){
			//Recupero el delegado
			return W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionNumDelCentSind(certificacion);
		}else if("SindicatoMasRepresentativo".equals(certificacion.getCertificacion())){
			return W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionSindMasRepresent(certificacion);
		}else if("DelegadosCentralSindical".equals(certificacion.getCertificacion())){
			//Saco el nmero de delegados de Araba, Bizkaia y Gipuzkoa poer convenio y sindicato
			List listaactas=W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionCentSind(certificacion, "individual");
			LinkedHashMap convenios=new LinkedHashMap();
			HashMap territorios=new HashMap();
			//Recupero las siglas del sindicato seleccionado
			String siglasSindicato = W83bFactoriaDAO.getCertificacionesDAO().recuperarCodigoSindicato(certificacion);
			for (int i=0;i<listaactas.size();i++){
				W83bCertificacionesBean cert = (W83bCertificacionesBean)listaactas.get(i);
				 territorios=new HashMap();
				territorios.put("ARABA",cert.getDelegadosAlava());
				territorios.put("BIZKAIA",cert.getDelegadosVizcaya());
				territorios.put("GIPUZKOA",cert.getDelegadosGuipuzcoa());
				territorios.put("TOTAL",String.valueOf(Integer.parseInt(cert.getDelegadosAlava())+Integer.parseInt(cert.getDelegadosVizcaya())+Integer.parseInt(cert.getDelegadosGuipuzcoa())));
				convenios.put(cert.getCodConvenio()+"|"+cert.getDescconvenio()+"|"+cert.getDeseconvenio()+"|"+siglasSindicato,territorios);
			}
			//Saco el nmero de delegados de Araba, Bizkaia y Gipuzkoa por convenio para todos los sindicatos, por eso le paso a la funcin el parmetro 'total', para que no incluya el filtro de sindicato
			List listaactasTotal=W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionCentSind(certificacion, "total");
			for (int i=0;i<listaactasTotal.size();i++){
				W83bCertificacionesBean certtotal = (W83bCertificacionesBean)listaactasTotal.get(i); 
				if (convenios.get(certtotal.getCodConvenio()+"|"+certtotal.getDescconvenio()+"|"+certtotal.getDeseconvenio()+"|"+siglasSindicato)!=null){
					territorios = (HashMap)convenios.get(certtotal.getCodConvenio()+"|"+certtotal.getDescconvenio()+"|"+certtotal.getDeseconvenio()+"|"+siglasSindicato);
					String resultado=(String)territorios.get("ARABA");
					resultado=resultado+"|"+certtotal.getDelegadosAlava();//NOPMD
					territorios.put("ARABA", resultado);
					resultado=(String)territorios.get("BIZKAIA");
					resultado=resultado+"|"+certtotal.getDelegadosVizcaya();//NOPMD
					territorios.put("BIZKAIA", resultado);
					resultado=(String)territorios.get("GIPUZKOA");
					resultado=resultado+"|"+certtotal.getDelegadosGuipuzcoa();//NOPMD
					territorios.put("GIPUZKOA", resultado);
					resultado=(String)territorios.get("TOTAL");
					resultado=resultado+"|"+String.valueOf(Integer.parseInt(certtotal.getDelegadosAlava())+Integer.parseInt(certtotal.getDelegadosVizcaya())+Integer.parseInt(certtotal.getDelegadosGuipuzcoa()));//NOPMD
					territorios.put("TOTAL", resultado);
					convenios.put(certtotal.getCodConvenio()+"|"+certtotal.getDescconvenio()+"|"+certtotal.getDeseconvenio()+"|"+siglasSindicato,territorios);
				}
				
			}
			certificacion.setListaConvenios(convenios);
			return certificacion;
		}
		else if("CentralesSindicalesConvenio".equals(certificacion.getCertificacion())){
			
			
			List lista = W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionSindConv(certificacion);
			HashMap hashTotalConvenio=new HashMap();
			HashMap hashTotalConvenioSindicato=new HashMap();
			List listaSindicatos;
			String aux;
			for(int i=0;i<lista.size();i++)
			{
				String codconvenio=((W83bCertificacionesBean)lista.get(i)).getCodConvenio();
				if(hashTotalConvenio.containsKey(codconvenio))
				{
					hashTotalConvenioSindicato=(HashMap)hashTotalConvenio.get(codconvenio);
					
				}else{
					hashTotalConvenioSindicato=new HashMap();//NOPMD
					hashTotalConvenioSindicato.put("alava", "0");
					hashTotalConvenioSindicato.put("bizkaia", "0");
					hashTotalConvenioSindicato.put("gipuzkoa", "0");
					
					
				}
				if(StringUtils.isNotEmpty(((W83bCertificacionesBean)lista.get(i)).getDelegadosAlava()))
				{
					aux=String.valueOf(Integer.parseInt((String)hashTotalConvenioSindicato.get("alava"))+Integer.parseInt(((W83bCertificacionesBean)lista.get(i)).getDelegadosAlava()));
					hashTotalConvenioSindicato.put("alava",aux);
					
				}
				if(StringUtils.isNotEmpty(((W83bCertificacionesBean)lista.get(i)).getDelegadosGuipuzcoa()))
				{
				aux=String.valueOf(Integer.parseInt((String)hashTotalConvenioSindicato.get("gipuzkoa"))+Integer.parseInt(((W83bCertificacionesBean)lista.get(i)).getDelegadosGuipuzcoa()));
				hashTotalConvenioSindicato.put("gipuzkoa",aux);
				}
				if(StringUtils.isNotEmpty(((W83bCertificacionesBean)lista.get(i)).getDelegadosVizcaya()))
				{
				aux=String.valueOf(Integer.parseInt((String)hashTotalConvenioSindicato.get("bizkaia"))+Integer.parseInt(((W83bCertificacionesBean)lista.get(i)).getDelegadosVizcaya()));
				hashTotalConvenioSindicato.put("bizkaia",aux);
				}
				hashTotalConvenio.put(codconvenio,hashTotalConvenioSindicato);
			
			}
		
			LinkedHashMap  miListaConvenios=new LinkedHashMap ();
			W83bCertificacionesBean lineaBD;
			W83bCertificacionesBean lineaHash;
			for (int i=0;i<lista.size();i++){
				
				lineaBD = (W83bCertificacionesBean)lista.get(i);
				if(miListaConvenios.containsKey(lineaBD.getCodConvenio()))
				{
					lineaHash=(W83bCertificacionesBean)miListaConvenios.get(lineaBD.getCodConvenio());
					lineaHash.getListaSindicatos().add(lineaBD);
					miListaConvenios.put(lineaBD.getCodConvenio(),lineaHash);
				}else{
					listaSindicatos=new ArrayList();//NOPMD
					listaSindicatos.add(lineaBD);
					lineaHash=new W83bCertificacionesBean();//NOPMD
					lineaHash.setListaSindicatos(listaSindicatos);
					lineaHash.setDelegadosAlava((String)((HashMap)hashTotalConvenio.get(lineaBD.getCodConvenio())).get("alava"));
					lineaHash.setDelegadosGuipuzcoa((String)((HashMap)hashTotalConvenio.get(lineaBD.getCodConvenio())).get("gipuzkoa"));
					lineaHash.setDelegadosVizcaya((String)((HashMap)hashTotalConvenio.get(lineaBD.getCodConvenio())).get("bizkaia"));
					lineaHash.setCodConvenio(lineaBD.getCodConvenio());
					lineaHash.setConvenio(lineaBD.getConvenio());					
					miListaConvenios.put(lineaBD.getCodConvenio(),lineaHash);
				}
			}

			certificacion.setListaConvenios(miListaConvenios);
						
			return certificacion;
			
			
		}else if("ComposicionOrganoRepresentacion".equals(certificacion.getCertificacion())){
			
			miCertificacion =  W83bFactoriaDAO.getCertificacionesDAO().cargaDatosGeneralesCertificacionOrganoRepresentacion(certificacion);			
			miCertificacion.setListaDelegados(W83bFactoriaDAO.getCertificacionesDAO().cargaListaDelegados(certificacion));
			
			return miCertificacion;
		}
		else if("Empresa".equals(certificacion.getCertificacion())){
			miCertificacion =  W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionEmpresa(certificacion);
			return miCertificacion;
		}
		
		else if("CentralesSindicalesSector".equals(certificacion.getCertificacion())){
			List lista= W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionPorSectores(certificacion);
			List listaTotales= W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionPorSectoresTotales(certificacion);
			lista.addAll(listaTotales);
			HashMap hashTotalSector=new HashMap();
			String aux;
			int auxInt;
			boolean encontrado;
			String[] listasectores=certificacion.getListaCodSector().split(",");
			String[] listasectoresdesc=certificacion.getDescSector().split("##");
			for(int i=0;i<lista.size();i++)
			{
				String codsector=((W83bCertificacionesBean)lista.get(i)).getSector();
				
				encontrado=false;
				for(int j=0;j<listasectores.length && !encontrado;j++)
					{
						if(codsector.equals(listasectores[j]))
						{
							((W83bCertificacionesBean)lista.get(i)).setDescSector(listasectoresdesc[j]);
							encontrado=true;
						}
					}
			
				if(hashTotalSector.containsKey(codsector))
				{
					aux=(String)hashTotalSector.get(codsector);
					auxInt=(Integer.parseInt(aux)+Integer.parseInt(((W83bCertificacionesBean)lista.get(i)).getDelegados()));
					hashTotalSector.put(codsector,String.valueOf(auxInt));
				}else{
					hashTotalSector.put(codsector,String.valueOf(Integer.parseInt(((W83bCertificacionesBean)lista.get(i)).getDelegados())));
				}
			}
			for(int j=0;j<lista.size();j++)
			{
				String codsector=((W83bCertificacionesBean)lista.get(j)).getSector();
				((W83bCertificacionesBean)lista.get(j)).setTotal((String)hashTotalSector.get(codsector));
			}
			certificacion.setListaSindicatos(lista);
			return certificacion;
		}
		else if("NegativoConvocatoria".equals(certificacion.getCertificacion())){
			String f= W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionNegativoConvocatoria(certificacion);
			certificacion.setNumActa(f);
			return certificacion;
		}
		else if("NegativoRepresentatividad".equals(certificacion.getCertificacion())){
			certificacion =  W83bFactoriaDAO.getCertificacionesDAO().cargaCertificacionNegativoRepresentatividad(certificacion);
			List descrip=W83bFactoriaDAO.getCertificacionesDAO().cargaDescripcionSindicato(certificacion);
			certificacion.setDescripcionSindicato(String.valueOf(descrip.get(0)));
			certificacion.setDescripcionSindicatoEusk(String.valueOf(descrip.get(1)));
			return certificacion;
		}
		else return certificacion;
	}
	
	
}